<?php
/**
 * @package		JoomlaFare.com Group Redirect
 * @copyright		(C) 2009 JoomlaFare.com. All rights reserved.
 * @license		GNU/GPL General Public License Version 2
 * @author		JoomlaFare.com <info@joomlafare.com>
 **/

defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.plugin.plugin' );
include_once (JPATH_SITE.DS.'components'.DS.'com_content'.DS.'helpers'.DS.'route.php');

/**
 * Plugin class for group_redirect
 */
class plgUserGroup_Redirect extends JPlugin
{
	/*
	 * Constructor
	 */
	function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
	}

	/*
	 * Function that handles the redirect. The redirect is
	 * based on a url specified as a module parameter
	 * @return	void
	 */
	function onLoginUser()
	{
		/*
		 * Skip when we're in the backend
		 */
		$app =& JFactory::getApplication();
		if ($app->isAdmin()) return;

		$user =& JFactory::getUser();
		$group = $user->usertype;

		switch ($group) {
			case "Registered":
			$link = $this->params->get('reg_url');
		    	break;
		    case "Author":
			$link = $this->params->get('auth_url');
		    	break;
		    case "Editor":
			$link = $this->params->get('edit_url');
		    	break;
		    case "Publisher":
			$link = $this->params->get('pub_url');
		    	break;
		    case "Manager":
			$link = $this->params->get('man_url');
		    	break;
		    case "Administrator":
			$link = $this->params->get('admin_url');
		    	break;
		    case "Super Administrator":
			$link = $this->params->get('super_url');
		    	break;
		}
		
			/*
			 * if the url is not set, no need to redirect
			 */
			if (empty($link)) {
				return;
			}	
		
			/* 
			 * a litle house cleaning
			 */
			$link = htmlspecialchars($link);
			
			/*
			 * redirect user
			 */
			if ($link) {
				header("Status: 303");
				header("Location: ".JRoute::_($link)."");
				exit();
			}
		}
	}
