<?php

/*
  JoomlaXTC Google Fonts Plugin

  version 1.1.0

  Copyright (C) 2010  Monev Software LLC.	All Rights Reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  THIS LICENSE MIGHT NOT APPLY TO OTHER FILES CONTAINED IN THE SAME PACKAGE.

  See COPYRIGHT.php for more information.
  See LICENSE.php for more information.

  Monev Software LLC
  www.joomlaxtc.com
 */

defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

class plgContentplugin_jxtc_gfonts extends JPlugin {

    public function onContentPrepare($context, &$row, &$params, $limitstart) {

        $adds = $this->params->get('adds', '');
        $families = $this->params->get('families', '');
        $families = explode("\n", $families);
        $size = $this->params->get('size', 0);

        $add_fonts = '';
        if ($adds != '')
            $add_fonts = '&subset=';

        if (is_array($adds))
            $add_fonts .= implode(",", $adds);
        else
            $add_fonts .= $adds;

        while (($ini = strpos(strtolower($row->text), "{gfont")) !== false) {
            $fin = strpos(strtolower($row->text), "{/gfont}", $ini);
            $text = substr($row->text, $ini + 7, $fin - $ini - 7);
            $split = strrpos($text, "}");
            $parms = trim(substr($text, 0, $split));
            $args = explode(';', $parms);
            array_push($families, $args[0]);
            $args[0] = "'" . $args[0] . "'";
            $parms = implode(';', $args);
            $html = '<span style="';
            if ($size) {
                $html .= 'font-size:' . $size . 'px;';
            }
            $html .= 'font-family:' . $parms . '" >' . substr($text, $split + 1) . '</span>';
            $row->text = substr_replace($row->text, $html, $ini, $fin + 8 - $ini);
        }
        $document = JFactory::getDocument();
        foreach ($families as $family) {
            if (empty($family)) {
                continue;
            }
            $family = str_replace(' ', '+', $family);
            $document->addStyleSheet('http://fonts.googleapis.com/css?family=' . $family . $add_fonts, 'text/css');
        }
    }

}

?>